<?php

namespace Devsaadat\ShopGostardeh\Telegram\Classes;

use Devsaadat\ShopGostardeh\Telegram\Enums\ReplyMarkup;
use Devsaadat\ShopGostardeh\Telegram\Enums\Buttons as ButtonType;
use Exception;
use Devsaadat\ShopGostardeh\Gostardeh\GostardehApi;

class CallbackQuery extends CommonMethods
{
    use Buttons;
    public function handle(object $update): void
    {
        global $database;
        $callback_query = $update->callback_query;
        $data = $callback_query->data;
        $callback_id = $callback_query->id;
        $message = $callback_query->message;
        $message_id = $message->message_id;
        $chat = $message->chat;
        $from = $callback_query->from;
        $chat_id = $chat->id;
        $chat_type = $chat->type;
        $from_id = $from->id;
        $first_name = $from->first_name;
        $last_name = $from->last_name;
        $username = $from->username;
        $this->userid = $from_id;
        $this->chatid = $chat_id;
        $this->messageid = $message_id;
        $this->username = $username;
        $this->user_name = $first_name . ' ' . $last_name;
        $this->chat_type = $chat_type;
        $this->update = $update;
        $getuser = $this->getUser();
        #==============================================
        if($data == "0") AnswerCallbackquery($callback_id, "این دکمه جهت نمایش اطلاعات است و کاربردی ندارد", true);
        elseif($data == "del") DeleteMessage($chat_id, $message_id);
        elseif(!$this->CONFIG['bot_status'] and !in_array($from_id, $this->ADMINS)) AnswerCallbackquery($callback_id, "در حال حاضر ربات غیرفعال است", true);
        elseif($chat_type !== 'private' and !in_array($from_id,$this->ADMINS)){
            AnswerCallbackquery($callback_id, "ربات قادر به پاسخگویی در این صفحه نیست", true);
        }
        //========================== [جوین اجباری] =======================
        elseif($data == "join"){
            if(count($this->checkJoin($from_id,"join")) > 0){
                AnswerCallbackquery($callback_id,"ابتدا عضو تمامی کانال ها شوید",true);
                return;
            }
            DeleteMessage($chat_id,$message_id);
            $this->SendMessageByName($chat_id,"start", "سلام خوش آمدید",$this->button(ButtonType::Official));
            $this->setCommand();
        }
        //======================== [ حساب من ] =======================
        elseif($data == 'myaccount'){
            $join_time = myJdate(timestamp: $getuser['join_time']);
            $mojodi = number_format($getuser['shop_mojodi']);
            DeleteMessage($chat_id,$message_id);
            SendMessage($chat_id,"👤 شناسه کاربری: <code>$from_id</code>
📆  زمان عضویت: $join_time

💰 اعتبار فعلی: <b>$mojodi</b> تومان", $this->button(ButtonType::Profile));
        }
        //=========================== [ افزایش موجودی ==================
        elseif($data == 'addBalance'){
            SendMessage($chat_id,"یک گزینه انتخاب کنید:", $this->CreateKeyboard($this->addBalanceBtn(), ReplyMarkup::Keyboard));
        }
        // تراکنش های من
        elseif(preg_match('/^mytransactions-([0-9]+)/',$data, $match)){
            $start = (int) $match[1];
            $countPays = $database->count(PAYMENTS_TABLE, ['user_id' => $from_id]);
            if($countPays > 0){
                $btn = $btn_ = [];
                $txt = "🗒 لیست تراکنش های شما:\n";
                $num = $start + 1;
                $next = $start + 10;
                $back = $start - 10;
                $getList = $database->select(PAYMENTS_TABLE, ['amount', 'time', 'status', 'order_id'], ['user_id' => $from_id]);
                foreach($getList as $fetch){
                    $amount = number_format($fetch['amount']);
                    $date = myJdate(timestamp: $fetch['time']);
                    $order_id = $fetch['order_id'];
                    $status = str_replace(['pending','done','canceled','unsuccess','rejected'],['در انتظار پرداخت','موفق','لغو شده','لغو شده','تایید نشده'],$fetch['status']);
                    $txt .= "\n$num. $date
💰 مبلغ: $amount تومان
♻️ وضعیت: <b>$status</b>
🏷 شماره پیگیری: <code>$order_id</code>
〰️〰️〰️〰️〰️〰️〰️〰️〰️〰️";
                    $num++;
                }
                if($back >= 0) $btn_[] = ['text' => $this->back_page_btn, 'callback_data' => "mytransactions-$back"];
                if($countPays > $next) $btn_[] = ['text' => $this->next_page_btn, 'callback_data' => "mytransactions-$next"];
                if(count($btn_) > 0) $btn[] = $btn_;
                $btn[] = [['text' => "بازگشت", 'callback_data' => "myaccount"]];
                editMessageText($chat_id,$txt, $message_id, $this->CreateKeyboard($btn, ReplyMarkup::InlineKeyboard));
            } else AnswerCallbackquery($callback_id,"⚠️ خطا! شما تا کنون هیچ تراکنشی انجام نداده اید",true);
        }
        //========================== [ پیگیری سفارش ] =================================
        elseif(preg_match('/^myOrders-([0-9]+)/',$data, $match)){
            $start = (int) $match[1];
            $countAll = $database->count(ORDERS_TABLE, ['user_id' => $from_id]);
            if($countAll > 0 ){
                editMessageText($chat_id, "کمی صبر کنید ...", $message_id);
                $btn = [];
                $next = $start + 5;
                $back = $start - 5;
                $count_pages = ceil($countAll / 5);
                $this_page = ceil(($start + 1) / 5);
                $txt = "🗒 لیست سفارش های شما: (صفحه $this_page از $count_pages)\n";
                $getList = $database->select(ORDERS_TABLE, '*', [
                    "user_id" => $from_id,
                    "ORDER" => ["time" => "DESC"],
                    "LIMIT" => [$start, 5]
                ]);
                try{
                    $Gostardeh = new GostardehApi($_ENV['GOSTARDEH']);
                    $getOrderByIds = $Gostardeh->getOrderByIds(array_column($getList, 'order_id'));
                } catch (Exception $e){
                    editMessageText($chat_id, "خطایی رخ داد. کمی بعد تلاش کنید", $message_id);
                    SendLog("خطایی در حین استعلام سفارشات کاربر رخ داد" . PHP_EOL . $e->getMessage());
                    return;
                }
                if($getOrderByIds['ok']) {
                    foreach ($getList as $fetch) {
                        $order = $getOrderByIds['result'][$fetch['order_id']];
                        $id = $fetch['id'];
                        $title = $fetch['title'];
                        $price_ = number_format($fetch['price']);
                        $quantity_ = number_format($fetch['quantity']);
                        $joined_ = number_format($order['joined_count']);
                        $remaining = number_format($order['remaining']);
                        $final_price_ = number_format($fetch['final_price']);
                        $date = myJdate(timestamp: $fetch['time']);
                        $status = $fetch['status'];
                        $status_ = str_replace(['pending', 'done', 'partial'], ['در حال انجام', 'تکمیل شده', 'ناقص شده'], $status);
                        $txt .= "\n🔅 شناسه: <code>$id</code>
🏷 موضوع: $title
🫂 تعداد ممبر درخواستی: $quantity_
🫂 تعداد عضو شده: $joined_
🫂 تعداد باقی مانده: $remaining
💰 قیمت هر 1000 عدد: $price_ تومان
💰 هزینه سفارش: $final_price_ تومان
📆 زمان ثبت: $date
وضعیت: <b>$status_</b>";
                        if ($order['cancel']) $txt .= PHP_EOL . "❌ لغو تبلیغ /cancel_ads_$id";
                        $txt .= PHP_EOL . "〰️〰️〰️〰️〰️〰️〰️〰️〰️〰️";
                    }
                    if ($back >= 0) {
                        $btn[] = ['text' => $this->back_page_btn, 'callback_data' => "myOrders-$back"];
                    }
                    if ($countAll > $next) {
                        $btn[] = ['text' => $this->next_page_btn, 'callback_data' => "myOrders-$next"];
                    }
                    if (count($btn) > 0) $btn = [$btn];
                    editMessageText($chat_id, $txt, $message_id, $this->CreateKeyboard($btn, ReplyMarkup::InlineKeyboard));
                } else {
                    editMessageText($chat_id, "خطایی رخ داد. کمی بعد تلاش کنید", $message_id);
                    SendLog("خطایی در حین استعلام سفارشات کاربر رخ داد" . PHP_EOL .$getOrderByIds['description']);
                }
            }
            else
            {
                AnswerCallbackquery($callback_id,"هیچ سفارشی یافت نشد", true);
            }
        }
        //-------- لغو تبلیغ
        elseif(preg_match('/^cancelAds_([0-9]+)$/', $data, $match)){
            $id = $match[1];
            $getAds = $database->get(ORDERS_TABLE,['status', 'chat_id','order_id', 'quantity', 'price', 'final_price', 'final_commission'], ['id' => $id, 'user_id' => $from_id]);
            if($getAds){
                if($getAds['status'] == 'pending'){
                    try {
                        $Gostardeh = new GostardehApi($_ENV['GOSTARDEH']);
                        $result = $Gostardeh->cancelOrder($getAds['order_id']);
                    } catch (Exception $e) {
                        SendLog("خطایی در حین لغو سفارش کاربران رخ داد" . PHP_EOL . $e->getMessage());
                        AnswerCallbackquery($callback_id, "خطایی رخ داد. کمی بعد تلاش کنید", true);
                        return;
                    }
                    if($result['ok']) {
                        $database->update(ORDERS_TABLE, ['status' => 'partial', 'joined' => $result['result']['joined']], ['id' => $id, 'user_id' => $from_id]);
                        editMessageText($chat_id, "❌ این تبلیغ متوقف شد.", $message_id);
                       // $joined = $result['result']['joined'];
                        $remaining = $result['result']['remaining'];
                        if($remaining > 0){
                            $final_price = $getAds['final_price'];
                            $final_commission = $getAds['final_commission'];
                            $quantity = $getAds['quantity'];
                            $final_price -= $final_commission;
                            $remaining_amount = ($final_price * (($remaining * 100) / $quantity)) / 100;
                            $remaining_amount_ = number_format($remaining_amount);
                            $database->update(USERS_TABLE, ['mojodi[+]' => $remaining_amount], ['user_id' => $from_id]);
                            SendMessage($chat_id, "➕💰 مبلغ $remaining_amount_ تومان بابت باقی مانده سفارشتان (با کسر کارمزد) به حسابتان عودت داده شد");
                        }
                    } else {
                        AnswerCallbackquery($callback_id, "خطایی رخ داد", true);
                        SendLog("خطایی در لغو سفارش رخ داد" . PHP_EOL . $result['description']);
                    }
                }else{
                    AnswerCallbackquery($callback_id,"این تبلیغ قبلا پایان یافته است",true);
                    DeleteMessage($chat_id, $message_id);
                }
            }else{
                AnswerCallbackquery($callback_id,"تبلیغ مورد نظر یافت نشد",true);
                DeleteMessage($chat_id, $message_id);
            }
        }
        //========================================== پنل ادمین ===========================
        elseif($data == "backadmin" and in_array($from_id,$this->ADMINS)){
            $this->setCommand();
            SendMessage($chat_id,"به منوی اصلی برگشتید.", $this->button(ButtonType::AdminPanel));
        }
        //============================= [ تغییر متن ها ] ==========================
        elseif($data == "setMessages" and in_array($chat_id,$this->ADMINS)){
            editMessageText($chat_id,"👇🏼 یک مورد را برای تغییر انتخاب کن", $message_id, $this->button(ButtonType::Messages));
            $this->setCommand();
        }
        elseif(preg_match('/^editText-(.*)/',$data, $match) and in_array($chat_id,$this->ADMINS)){
            
            $txt = $match[1];
            editMessageText($chat_id,"یک گزینه را انتخاب کنید :", $message_id, $this->CreateKeyboard([
                [['text' => "📬 پیام های فعلی", 'callback_data' => "msgs-$txt"],['text' => "➕ افزودن پیام", 'callback_data' => "addmsg-$txt"]],
                [['text' => "بازگشت", 'callback_data' => "setMessages"]],
            ], ReplyMarkup::InlineKeyboard));
        }
        elseif(preg_match('/^addmsg-(.*)/',$data, $match) and in_array($chat_id,$this->ADMINS)){
            
            SendMessage($chat_id,"👈 پیام جدید را ارسال کنید :",$this->button(ButtonType::BackAdmin));
            $this->setCommand($data);
        }
        elseif(preg_match('/^msgs-(.*)/',$data, $match) and in_array($chat_id,$this->ADMINS)){
            $txt = $match[1];
            $getall = $database->select(MESSAGES_TABLE, ['id', 'type', 'file_id', 'text', 'caption', 'pin'], ['name' => $txt]);
            if(count($getall) > 0){
                foreach( $getall as $fetch ){
                    $button = $this->CreateKeyboard([
                        [['text' => "📍پین شدن: ". str_replace([0,1],['⭕️','✅'],$fetch['pin']), 'callback_data' => "pinmsg-{$fetch['id']}"]],
                        [['text' => "❌ حذف", 'callback_data' => "delmsg-{$fetch['id']}"]],
                    ], ReplyMarkup::InlineKeyboard);
                    if($fetch['type'] == 'text') SendMessage($chat_id,$fetch['text'],$button);
                    else SendFile($chat_id,$fetch['type'],$fetch['file_id'],$fetch['caption'],$button);
                }
            }else AnswerCallbackquery($callback_id,"هیچ پیامی ثبت نشده است",true);
        }
        elseif(preg_match('/^pinmsg-([0-9]+)/',$data, $match) and in_array($chat_id,$this->ADMINS)){
            
            $id = $match[1];
            $getMessage = $database->get(MESSAGES_TABLE, ['pin'], ['id' => $id]);
            $pin = $getMessage['pin'];
            if($pin == 1){
                $pin = 0;
                AnswerCallbackquery($callback_id,"غیرفعال شد");
            }
            else
            {
                $pin = 1;
                AnswerCallbackquery($callback_id,"فعال شد");
            }
            $database->update(MESSAGES_TABLE, ['pin' => $pin], ['id' => $id]);
            editMessageReplyMarkup($chat_id, $message_id, json_encode(['inline_keyboard' => [
                [['text' => "📍پین شدن: ". str_replace([0,1],['⭕️','✅'],$pin), 'callback_data' => "pinmsg-$id"]],
                [['text' => "❌ حذف", 'callback_data' => "delmsg-$id"]],
            ]]));
        }
        elseif(preg_match('/^delmsg-([0-9]+)/',$data, $match) and in_array($chat_id,$this->ADMINS)){
            
            $id = $match[1];
            $database->delete(MESSAGES_TABLE, ['id' => $id]);
            AnswerCallbackquery($callback_id,"حذف شد",true);
            DeleteMessage($chat_id,$message_id);
        }
        //============================= [ ادمین ها ] ================================
        elseif($data == 'admins' and in_array($chat_id,$this->ADMINS)){
            editMessageText($chat_id,"👈🏽 به بخش #ادمین_ها خوش آمدید", $message_id, $this->CreateKeyboard($this->admins_list(), ReplyMarkup::InlineKeyboard));
        }
        elseif(preg_match('/^deleteAdmin-([0-9]+)/',$data, $match) and in_array($chat_id,$this->ADMINS)){
            $id = $match[1];
            $database->delete(ADMINS_TABLE, ['id' => $id]);
            $btn = $this->admins_list();
            editMessageReplyMarkup($chat_id,$message_id,$this->CreateKeyboard($btn, ReplyMarkup::InlineKeyboard));
            AnswerCallbackquery($callback_id,"حذف شد",true);
        }
        elseif($data == 'addAdmin' and in_array($chat_id,$this->ADMINS)){
            
            SendMessage($chat_id,"🆔 ایدی عددی کاربر مورد نظر را با اعداد لاتین ارسال کنید و یا با استفاده از دکمه زیر کاربر مورد نظر را انتخاب کنید :",$this->button(ButtonType::SelectUser));
            $this->setCommand($data);
        }
        //======================== [تنظیمات] =============================
        elseif(preg_match('/^botSetting-(.*)/',$data, $match) and in_array($chat_id,$this->ADMINS)){
            $target = $match[1];
            if($this->CONFIG[$target]){
                $this->CONFIG[$target]= false;
                AnswerCallbackquery($callback_id,"غیرفعال شد");
            }else{
                $this->CONFIG[$target]= true;
                AnswerCallbackquery($callback_id,"فعال شد");
            }
            file_put_contents(CONFIG_FILE_DIR, json_encode($this->CONFIG));
            editMessageReplyMarkup($chat_id,$message_id, $this->CreateKeyboard($this->botConfigBtn($this->CONFIG), ReplyMarkup::InlineKeyboard));
        }
        //===================== [ ارسال همگانی ] ==========================
        elseif(preg_match('/^cancelSend-([0-9]+)/',$data, $match) and in_array($chat_id,$this->ADMINS)){
            $send = $database->get(SEND_TABLE, ['status'], ['id' => $match[1]]);
            if($send and $send['status'] == 'pending'){
                $database->delete(SEND_TABLE, ['id' => $match[1]]);
                AnswerCallbackquery($callback_id, "❌ ارسال لغو شد", true);
                DeleteMessage($chat_id, $message_id);
            } else {
                AnswerCallbackquery($callback_id, "امکان لغو این ارسال وجود ندارد", true);
            }
        }
        //======================= [ اطلاعات کاربر ] ==================================
        elseif (preg_match('/^searchUser-([0-9]+)/', $data, $match) and in_array($chat_id, $this->ADMINS)) {
            $user_id = $match[1];
            $search = $this->getUser($user_id);
            if ($search) {
                DeleteMessage($chat_id, $message_id);
                $join_time = myJdate(timestamp: $search['join_time']);
                $mojodi = number_format($search['mojodi']);
                SendMessage($chat_id,"- زمان عضویت: $join_time
            - موجودی فعلی: $mojodi تومان", $this->CreateKeyboard($this->userBtn($search), ReplyMarkup::InlineKeyboard));
                $this->setCommand();
            } else SendMessage($chat_id, "❗️ این کاربر عضو ربات نیست", $this->button(ButtonType::SelectUser), $message_id);
        }
        elseif (preg_match('/^block-([0-9]+)/', $data, $match) and in_array($chat_id, $this->ADMINS)) {
            $user_id = $match[1];
            $getUser = $this->getUser($user_id, ['user_id', 'block']);
            $getUser['block'] = !$getUser['block'];
            $database->update(USERS_TABLE, ['block' => $getUser['block']], ['user_id' => $user_id]);
            AnswerCallbackquery($callback_id, "انجام شد");
            editMessageReplyMarkup($chat_id, $message_id, $this->CreateKeyboard($this->userBtn($getUser), ReplyMarkup::InlineKeyboard));
        }
        elseif (preg_match('/^userMessage-([0-9]+)/', $data, $match) and in_array($chat_id, $this->ADMINS)) {
            $user_id = $match[1];
            editMessageText($chat_id, "پیام خود را ارسال کنید :", $message_id, $this->CreateKeyboard([
                [['text' => $this->back_admin_btn, 'callback_data' => "searchUser-$user_id"]]
            ], ReplyMarkup::InlineKeyboard));
            $this->setCommand($data);
        }
        elseif(preg_match('/^userMojodi-[0-9]+/',$data) and in_array($from_id,$this->ADMINS)){
            SendMessage($chat_id,"چه مقدار از موجودی کاربر کسر و یا به آن اضافه گردد؟ ( برای کسر کردن یک علامت منفی قبل از عدد بگذارید )",$this->button(ButtonType::BackAdmin));
            $this->setCommand($data);
        }
        elseif(preg_match('/^userTransactions-([0-9]+)-([0-9]+)/',$data, $match) and in_array($from_id,$this->ADMINS)){
            $user_id = $match[1];
            $start = (int) $match[2] ?: 0;
            $countAll = $database->count(PAYMENTS_TABLE, ['user_id' => $user_id]);
            if($countAll > 0 ){
                $txt = '';
                $x = 10;
                $num = $start + 1;
                $next = $start + $x;
                $back = $start - $x;
                $btn = [];
                $list = $database->select(PAYMENTS_TABLE, ['id', 'amount', 'order_id', 'status', 'time'], ['user_id' => $user_id, 'LIMIT' => [$start, $x]]);
                foreach($list as $fetch){
                    $amount = number_format($fetch['amount']);
                    $date = myJdate(timestamp: $fetch['time']);
                    $order_id = $fetch['order_id'];
                    $status = str_replace(['pending','done','canceled','unsuccess','rejected', 'waiting'],['در انتظار پرداخت','موفق','لغو شده','لغو شده','تایید نشده', 'در انتظار پرداخت'],$fetch['status']);
                    $txt .= "\n$num. $date
💰 مبلغ: $amount تومان
♻️ وضعیت: <b>$status</b>
🏷 شماره پیگیری: <code>$order_id</code>
〰️〰️〰️〰️〰️〰️〰️〰️〰️〰️";
                    $num++;
                }
                if($back >= 0 ){
                    $btn[] = ['text' => $this->back_page_btn, 'callback_data' => "userTransactions-$user_id-$back"];
                }
                if($countAll > $next ){
                    $btn[] = ['text' => $this->next_page_btn, 'callback_data' => "userTransactions-$user_id-$next"];
                }
                $btn = array_merge([$btn], [
                    [['text' => $this->back_admin_btn, 'callback_data' => "searchUser-$user_id"]]
                ]);
                editMessageText($chat_id,"لیست برداشت های کاربر:\n$txt", $message_id, $this->CreateKeyboard($btn, ReplyMarkup::InlineKeyboard));
            }
            else{
                AnswerCallbackquery($callback_id,"هیچ موردی یافت نشد", true);
            }
        }
        elseif(preg_match('/^userOrders-([0-9]+)-([0-9]+)/',$data, $match) and in_array($from_id,$this->ADMINS)){
            $user_id = $match[1];
            $start = (int) $match[2] ?: 0;
            $countAll = $database->count(ORDERS_TABLE, [
                'user_id' => $user_id,
            ]);
            if($countAll > 0 ){
                $txt = '';
                $x = 10;
                $next = $start + $x;
                $back = $start - $x;
                $btn = [];
                $getList = $database->select(ORDERS_TABLE, '*',
                    [
                        "user_id" => $user_id, // شرط user_id
                        "ORDER" => ["time" => "DESC"], // مرتب‌سازی نزولی بر اساس start_time
                        "LIMIT" => [$start, 5] // محدودیت تعداد رکوردها
                    ]
                );

                foreach($getList as $fetch){
                    $id = $fetch['id'];
                    $title = $fetch['title'];
                    $quantity = $fetch['quantity'];
                    $gift = $fetch['gift'];
                    $price_ = number_format($fetch['price']);
                    $final_price = number_format($fetch['final_price']);
                    $api_price = number_format($fetch['api_price']);
                    $gift_price = number_format($gift);
                    $gift_users = $fetch['gift_users'];
                    $quantity_ = number_format($quantity);
                    $date = myJdate(timestamp: $fetch['time']);
                    $status = $fetch['status'];
                    $status_ = str_replace(['pending', 'done', 'partial'], ['در حال انجام', 'تکمیل شده', 'ناقص شده'], $status);
                    $txt .= "\n🔅 شناسه: <code>$id</code>
🏷 موضوع: $title
🫂 تعداد ممبر درخواستی: $quantity_
💰 قیمت هر 1000 عدد: $price_ تومان
💰 هزینه سفارش: $final_price تومان
💰 هزینه وبسرویس: $api_price تومان
📆 زمان ثبت: $date
وضعیت: <b>$status_</b>";
                    if($status == 'partial' or $status == 'done') $txt .= " (تعداد عضو شده: {$fetch['joined']})";
                    if($gift > 0){
                        $txt .= PHP_EOL . "🎁 هدیه: $gift_price تومان برای $gift_users نفر";
                    }
                    if($status == 'pending') $txt .= PHP_EOL . "❌ لغو تبلیغ /cancel_ads_$id";
                    $txt .= PHP_EOL . "〰️〰️〰️〰️〰️〰️〰️〰️〰️〰️";
                }
                if($back >= 0 ){
                    $btn[] = ['text' => $this->back_page_btn, 'callback_data' => "userOrders-$user_id-$back"];
                }
                if($countAll > $next ){
                    $btn[] = ['text' => $this->next_page_btn, 'callback_data' => "userOrders-$user_id-$next"];
                }
                if(count($btn) > 0) $btn = [$btn];
                $btn[] = [['text' => $this->back_admin_btn, 'callback_data' => "searchUser-$user_id"]];
                editMessageText($chat_id,"🗒 لیست سفارش های کاربر\n\n$txt", $message_id, $this->CreateKeyboard($btn, ReplyMarkup::InlineKeyboard));
            }
            else{
                AnswerCallbackquery($callback_id,"هیچ موردی یافت نشد", true);
            }
        }
        //======================== [] ==============================
        elseif($data == 'channels' and in_array($from_id,$this->ADMINS)){
            editMessageText($chat_id,"👈🏽 به بخش #کانال_ها (اسپانسری) خوش آمدید", $message_id, $this->CreateKeyboard($this->force_join_channels(), ReplyMarkup::InlineKeyboard));
            $this->setCommand();
        }
        elseif(preg_match('/^delch-([0-9]+)/',$data, $match) and in_array($from_id,$this->ADMINS)){
            AnswerCallbackquery($callback_id,"کمی صبر کنید...");
            $database->delete(CHANNELS_TABLE, ['id' => $match[1]]);
            editMessageReplyMarkup($chat_id,$message_id, $this->CreateKeyboard($this->force_join_channels(), ReplyMarkup::InlineKeyboard));
        }
        elseif(preg_match('/^etchn-([0-9]+)/',$data, $match) and in_array($from_id,$this->ADMINS)){
            AnswerCallbackquery($callback_id,"کمی صبر کنید...");
            $btn[] = [['text' => "🔄 بازگشت",'callback_data' => 'channels']];
            editMessageText($chat_id,"عنوان جدید این کانال را ارسال کنید:", $message_id, $this->CreateKeyboard($btn, ReplyMarkup::InlineKeyboard));
            $this->setCommand($data);
        }
        elseif($data == 'addChannels' and in_array($from_id,$this->ADMINS)){
            SendMessage($chat_id, "کانال یا گروه مورد نظرت رو انتخاب کن:
                
                ⚠️ توجه: ابتدا ربات  را در آن ادمین کنید", $this->button(ButtonType::SelectChat));
            $this->setCommand("channels-addNew");
        }



    }
}