<?php

namespace Devsaadat\ShopGostardeh;

use Devsaadat\ShopGostardeh\Telegram\Classes\Message;
use Devsaadat\ShopGostardeh\Telegram\Classes\CallbackQuery;
class Controller {
    public function processUpdate($update): void
    {

        // بررسی نوع پیام و انتخاب ماژول مناسب
        if($update->message){
            // دریافت پیام معمولی
            $this->loadModule(Message::class, $update);
        }
        else if($update->callback_query){
            // دکمه های شیشه ای
            $this->loadModule(CallBackQuery::class, $update);
        }
        else return;

    }

    private function loadModule($moduleName, $update): void
    {
        if (class_exists($moduleName)) {
            $module = new $moduleName();
            $module->handle($update);
        } else {
            error("Module $moduleName not found!");
            SendLog("Module $moduleName not found!");
        }
    }
}