<html lang="fa" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>نصب/آپدیت ربات</title>
    <!-- Bootstrap 5 (CDN) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body{background:linear-gradient(180deg,#f8fafc,#ffffff);min-height:100vh}
        .card{border-radius:16px;box-shadow:0 6px 18px rgba(20,20,40,.06)}
        .form-label{font-weight:600}
        .required::after{content:" *";color:#d6336c}
        .spinner-border{width:1.25rem;height:1.25rem}
    </style>
</head>
<body>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-12 col-md-8 col-lg-6">
            <div class="card p-4">
                <h4 class="mb-3 text-center">نصب / آپدیت ربات</h4>
                <form id="installForm" novalidate>

                    <div class="mb-3">
                        <label class="form-label required">توکن ربات تلگرامی از
                        <small><a href="https://t.me/botfather" target="_blank">بات فادر</a></small> </label>
                        <input type="text" id="botToken" name="botToken" class="form-control" placeholder="مثال: 123456789:ABCDefGhIJKlmnoPQRstuVwxyz_1234567890" required>
                        <div class="invalid-feedback" id="botTokenError"></div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label required">آیدی عددی ادمین
                        <small>(برای بدست آوردن آیدی عددی اکانت خود <a href="https://t.me/goldsudobot" target="_blank">اینجا</a> کلیک کنید)</small></label>
                        <input type="text" id="adminId" name="adminId" class="form-control" placeholder="مثال: 123456789" required>
                        <div class="invalid-feedback" id="adminIdError"></div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label required">کلید وبسرویس</label>
                        <input type="text" id="apikey" name="apikey" class="form-control" placeholder="مثال: AsddCDefGhIJKlmnoPQRstuVwxyz67890" required>
                        <div class="invalid-feedback" id="apikeyError"></div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label required">نام دیتابیس
                            <small>(<a href="https://parspack.com/blog/controlpanel/cpanel/cpanel-database" target="_blank">آموزش ساخت دیتابیس</a>)</small></label>
                        <input type="text" id="dbName" name="dbName" class="form-control" placeholder="db_name" required>
                        <div class="invalid-feedback" id="dbNameError"></div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label required">یوزرنیم دیتابیس</label>
                        <input type="text" id="dbUser" name="dbUser" class="form-control" placeholder="db_user" required>
                        <div class="invalid-feedback" id="dbUserError"></div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label required">پسورد دیتابیس</label>
                        <input type="password" id="dbPass" name="dbPass" class="form-control" placeholder="••••••" required>
                        <div class="invalid-feedback" id="dbPassError"></div>
                    </div>

                    <div class="d-grid gap-2">
                        <button id="submitBtn" class="btn btn-primary btn-lg" type="submit">
                            <span id="btnText">ارسال و نصب</span>
                            <span id="btnSpinner" class="ms-2 d-none"><span class="spinner-border" role="status" aria-hidden="true"></span></span>
                        </button>
                    </div>

                    <div class="mt-3" id="serverMessage" style="display:none"></div>

                </form>
            </div>

            <p class="text-center mt-3 small text-muted">در صورت وجود هرگونه مشکل و درخواست هرگونه آپدیت شخصی و برای ارتباط با برنامه نویس ربات
                <a href="https://t.me/devsaadat" target="_blank">اینجا</a>
                کلیک کنید.</p>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
    (function(){
        const form = document.getElementById('installForm');
        const submitBtn = document.getElementById('submitBtn');
        const btnText = document.getElementById('btnText');
        const btnSpinner = document.getElementById('btnSpinner');
        const serverMessage = document.getElementById('serverMessage');

        function setLoading(on){
            if(on){
                submitBtn.disabled = true;
                btnSpinner.classList.remove('d-none');
            } else {
                submitBtn.disabled = false;
                btnSpinner.classList.add('d-none');
            }
        }

        function showFieldError(id, msg){
            const el = document.getElementById(id);
            el.classList.add('is-invalid');
            document.getElementById(id + 'Error').textContent = msg;
        }
        function clearFieldError(id){
            const el = document.getElementById(id);
            el.classList.remove('is-invalid');
            document.getElementById(id + 'Error').textContent = '';
        }

        // Validation rules
        const tokenRegex = /^\d+:[A-Za-z0-9_\-]{20,}$/; // ساده و محافظه‌کارانه
        const apikeyRegex = /^[A-Za-z0-9]{20,}$/; // ساده و محافظه‌کارانه
        const nameRegex = /^[A-Za-z0-9_\-]+$/;
        const adminRegex = /^\d+$/;

        form.addEventListener('submit', function(e){
            e.preventDefault();
            // clear
            ['botToken','adminId', 'apikey','dbName','dbUser','dbPass'].forEach(clearFieldError);
            serverMessage.style.display = 'none';

            const data = {
                botToken: document.getElementById('botToken').value.trim(),
                adminId: document.getElementById('adminId').value.trim(),
                dbName: document.getElementById('dbName').value.trim(),
                apikey: document.getElementById('apikey').value.trim(),
                dbUser: document.getElementById('dbUser').value.trim(),
                dbPass: document.getElementById('dbPass').value
            };

            let hasError = false;

            if(!data.botToken) { showFieldError('botToken','توکن ربات الزامی است'); hasError = true; }
            else if(!tokenRegex.test(data.botToken)){ showFieldError('botToken','فرمت توکن نامعتبر است'); hasError = true; }

            if(!data.adminId){ showFieldError('adminId','آیدی ادمین الزامی است'); hasError = true; }
            else if(!adminRegex.test(data.adminId)){ showFieldError('adminId','آیدی فقط باید شامل اعداد باشد'); hasError = true; }

            if(!data.apikey){ showFieldError('apikey','کلید وبسرویس الزامی است'); hasError = true; }
            else if(!apikeyRegex.test(data.apikey)){ showFieldError('apikey','کلید وبسرویس نامعتبر است'); hasError = true; }

            if(!data.dbName){ showFieldError('dbName','نام دیتابیس الزامی است'); hasError = true; }
            else if(!nameRegex.test(data.dbName)){ showFieldError('dbName','نام دیتابیس فقط می‌تواند شامل حروف، اعداد، - یا _ باشد'); hasError = true; }

            if(!data.dbUser){ showFieldError('dbUser','یوزرنیم دیتابیس الزامی است'); hasError = true; }
            else if(!nameRegex.test(data.dbUser)){ showFieldError('dbUser','یوزرنیم فقط می‌تواند شامل حروف، اعداد، - یا _ باشد'); hasError = true; }

            if(!data.dbPass){ showFieldError('dbPass','پسورد دیتابیس الزامی است'); hasError = true; }

            if(hasError) return;

            setLoading(true);

            // ارسال به سرور با fetch (AJAX)
            fetch('installer.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            })
                .then(r => r.json())
                .then(resp => {
                    setLoading(false);
                    if(resp.success){
                        serverMessage.style.display = 'block';
                        serverMessage.className = 'alert alert-success mt-3';
                        serverMessage.textContent = resp.message || 'عملیات با موفقیت انجام شد.';
                    } else {
                        serverMessage.style.display = 'block';
                        serverMessage.className = 'alert alert-danger mt-3';
                        if(resp.errors){
                            // نمایش خطاها در فیلدها
                            Object.keys(resp.errors).forEach(k => {
                                const map = { botToken:'botToken', adminId:'adminId', dbName:'dbName', dbUser:'dbUser', dbPass:'dbPass' };
                                if(map[k]) showFieldError(map[k], resp.errors[k]);
                            });
                            // پیغام عمومی
                            const other = resp.message ? ('\n' + resp.message) : '';
                            serverMessage.textContent = 'خطا در مقادیر وارد شده.' + other;
                        } else {
                            serverMessage.textContent = resp.message || 'خطای ناشناخته رخ داد.';
                        }
                    }
                })
                .catch(err => {
                    setLoading(false);
                    serverMessage.style.display = 'block';
                    serverMessage.className = 'alert alert-danger mt-3';
                    serverMessage.textContent = 'خطا در ارتباط با سرور: ' + err.message;
                });

        });

    })();
</script>
</body>
</html>