<?php

ini_set("log_errors", 1);
ini_set("error_log", __DIR__ . "/src/Storage/logs/errors.log");
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING & ~E_DEPRECATED);
date_default_timezone_set('Asia/Tehran');
require_once __DIR__ . "/vendor/autoload.php";
//------------------------
const ENV_FILE_DIR = __DIR__ . '/.env';
const CONFIG_FILE_DIR = __DIR__ . "/src/Config/config.json";
const SETTING_FILE_DIR = __DIR__ . "/src/Config/setting.json";
const ERROR_LOGS_FILE_DIR = __DIR__ . "/src/Storage/logs/errors.log";
const USERS_TABLE = 'users_tbl';
const MESSAGES_TABLE = 'messages_tbl';
const ADMINS_TABLE = 'admins_tbl';
const SEND_TABLE = 'send_tbl';
const CHANNELS_TABLE = 'channels_tbl';
const PAYMENTS_TABLE = 'payments_tbl';
const ORDERS_TABLE = 'orders_tbl';
const COMMISSION_TABLE = "commission_tbl";
//------------------------
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();
$database = db_connect();
if(!$database) die("Database connection failed");
//---------------------------
define("API_KEY", $_ENV['API_KEY']);
define("ADMIN", $_ENV['ADMIN']);
define("LOG_CHAT", $_ENV['ADMIN']);
define("BOT_ID", $_ENV['BOT_ID']);
define("BOT_USERNAME", $_ENV['BOT_USERNAME']);
$WEBHOOK_KEY = $_ENV['WEBHOOK_KEY'];
//---------------------------
$headers = apache_request_headers();
if($WEBHOOK_KEY != "" and isset($_SERVER['X-Telegram-Bot-Api-Secret-Token']) and $_SERVER['X-Telegram-Bot-Api-Secret-Token'] != $WEBHOOK_KEY){
    http_response_code(503);
    die("Access denied");
}

use Devsaadat\ShopGostardeh\Controller;

$update = file_get_contents('php://input');
if($update){
    $database = db_connect();
    if(!$database) die();
    $moduleLoader = new Controller();
    $moduleLoader->processUpdate(json_decode($update));
}
else
{
    http_response_code(502);
    error($_SERVER['REMOTE_ADDR'] ." Tried to touch bot webhook file");
    SendLog($_SERVER['REMOTE_ADDR'] ." Tried to touch bot webhook file");
    die("Invalid Request");
}